<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\QuoteAddressTotal;

class QuoteSelected extends Quote {
    /**
     * @var ?QuoteSelectedPoints
     */
    private $points;

    public function getPoints(): QuotePoints {
        if( ! $this->points) {
            $this->points = new QuoteSelectedPoints($this->type, $this->total, $this->quote, $this->provider);
        }

        return $this->points;
    }

    public function getCurrency(): QuoteCurrency {
        return new QuoteSelectedCurrency($this->total, $this->quote);
    }

    public function getShipping(): ?QuoteShipping {
        if($this->quote->isVirtual()) {
            return null;
        }

        $amounts = $this->getShippingAmounts();

        if( ! $amounts) {
            return null;
        }

        return new QuoteSelectedShipping($this->total, $amounts, $this->quote);
    }

    public function getDiscount(): ?QuoteDiscount {
        $discount = array_values(array_filter($this->total->getDiscount()));
        $discountPoints = array_values(array_filter($this->total->getPointsDiscount()));

        if(empty($discount)) {
            return null;
        }

        return new QuoteSelectedDiscount($discount, $discountPoints, $this->quote);
    }
}
