<?php

declare(strict_types=1);

namespace Fixtures;

use Crossroads\Magento\Test\Integration\MagentoManager;
use Mage;
use Mage_Customer_Model_Group;
use Points\Core\Extension\Product;

function loadPoints(): void {
    MagentoManager::reset();
    MagentoManager::initAdmin();

    $store = Mage::app()->getStore(MagentoManager::TESTING_STORE);
    $adminStore = Mage::app()->getStore();
    $simple = Mage::getModel("catalog/product");
    /**
     * @var Product $virtual
     */
    $virtual = Mage::getModel("catalog/product");
    $config1 = Mage::getModel("catalog/product");
    $config2 = Mage::getModel("catalog/product");
    $simplePrice = Mage::getModel("points_core/product_price");
    $simplePriceGlobal = Mage::getModel("points_core/product_price");
    $virtualPrice = Mage::getModel("points_core/product_price");
    $configPrice1 = Mage::getModel("points_core/product_price");
    $configPrice2 = Mage::getModel("points_core/product_price");

    $simple->setStoreId(Mage::app()->getStore()->getId())
        ->load(Mage::getModel("catalog/product")->getIdBySku("test-simple"));

    $virtual->setStoreId(Mage::app()->getStore()->getId())
        ->load(Mage::getModel("catalog/product")->getIdBySku("test-virtual"));

    $config1->setStoreId(Mage::app()->getStore()->getId())
        ->load(Mage::getModel("catalog/product")->getIdBySku("test-config-child-1"));

    $config2->setStoreId(Mage::app()->getStore()->getId())
        ->load(Mage::getModel("catalog/product")->getIdBySku("test-config-child-2"));

    $virtual->setPointsPaymentRequired(true);
    $virtual->save();

    $simplePrice->loadByStoreProductTypeCustomerGroupId($store, $simple, "TEST", Mage_Customer_Model_Group::NOT_LOGGED_IN_ID);
    $simplePrice->addData([
        "store_id" => $store->getId(),
        "product_id" => $simple->getId(),
        "customer_group_id" => Mage_Customer_Model_Group::NOT_LOGGED_IN_ID,
        "type" => "TEST",
        "price" => 1332,
        "min_price" => 0,
        "max_price" => null,
    ]);
    $simplePrice->save();

    $simplePriceGlobal->loadByStoreProductTypeCustomerGroupId($adminStore, $simple, "TEST", Mage_Customer_Model_Group::NOT_LOGGED_IN_ID);
    $simplePriceGlobal->addData([
        "store_id" => 0,
        "product_id" => $simple->getId(),
        "customer_group_id" => Mage_Customer_Model_Group::NOT_LOGGED_IN_ID,
        "type" => "TEST",
        "price" => 99999,
        "min_price" => 0,
        "max_price" => null,
    ]);
    $simplePriceGlobal->save();

    $virtualPrice->loadByStoreProductTypeCustomerGroupId($store, $virtual, "TEST", Mage_Customer_Model_Group::NOT_LOGGED_IN_ID);
    $virtualPrice->addData([
        "store_id" => $store->getId(),
        "product_id" => $virtual->getId(),
        "customer_group_id" => Mage_Customer_Model_Group::NOT_LOGGED_IN_ID,
        "type" => "TEST",
        "price" => 1999,
        "min_price" => 499,
        "max_price" => 1499,
    ]);
    $virtualPrice->save();

    $configPrice1->loadByStoreProductTypeCustomerGroupId($store, $config1, "TEST", Mage_Customer_Model_Group::NOT_LOGGED_IN_ID);
    $configPrice1->addData([
        "store_id" => $store->getId(),
        "product_id" => $config1->getId(),
        "customer_group_id" => Mage_Customer_Model_Group::NOT_LOGGED_IN_ID,
        "type" => "TEST",
        "price" => 899,
        "min_price" => 99,
        "max_price" => 1499,
    ]);
    $configPrice1->save();

    $configPrice2->loadByStoreProductTypeCustomerGroupId($store, $config2, "TEST", Mage_Customer_Model_Group::NOT_LOGGED_IN_ID);
    $configPrice2->addData([
        "store_id" => $store->getId(),
        "product_id" => $config2->getId(),
        "customer_group_id" => Mage_Customer_Model_Group::NOT_LOGGED_IN_ID,
        "type" => "TEST",
        "price" => 799,
        "min_price" => 0,
        "max_price" => null,
    ]);
    $configPrice2->save();

    Mage::getSingleton("points_core/product_index")->reindexAll();

    MagentoManager::reset();
}

function loadPointLimits(): void {
    // TODO
}
