<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;

use Points\Core\QuoteAddressTotal;
use Points\Core\Points;
use Points\Core\Currency;
use Points\Core\Extension\Quote as QuoteExt;

class QuoteSelectedDiscount extends QuoteDiscount {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param Array<Currency> $currency
     * @param Array<Points> $points
     * @param QuoteExt $quote
     */
    public function __construct(
        array $currency,
        array $points,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($currency, $points);

        $this->quote = $quote;
    }

    public function getPoints(): QuoteDiscountPoints {
        $incl = array_sum(array_map("Points\Core\Amount::totalInclTax", array_filter($this->currency, "Points\Core\Currency::isIncluded")));
        $excl = array_sum(array_map("Points\Core\Amount::totalInclTax", array_filter($this->currency, "Points\Core\Currency::isNotIncluded")));

        $incRate = ($incl + $excl) > 0 ? $incl / ($incl + $excl) : 0;

        return new QuoteSelectedDiscountPoints($this->points, $incRate, $this->quote);
    }

    public function getCurrency(): QuoteDiscountCurrency {
        return new QuoteSelectedDiscountCurrency($this->currency, $this->quote);
    }
}
