<?php

use Points\Core\Extension\Product as ProductExt;

class Points_Core_Model_Product_PointsPaymentRequired {
    private static function getRegistryKey(Mage_Core_Model_Store $store): string {
        return sprintf("points_core_product_points_payment_required_", $store->getId());
    }

    public static function instance(Mage_Core_Model_Store $store): self {
        $key = self::getRegistryKey($store);
        $instance = Mage::registry($key);

        if( ! $instance) {
            $instance = new self($store);

            Mage::register($key, $instance);
        }

        return $instance;
    }

    /**
     * @var Array<int>
     */
    protected $productIds = [];

    /**
     * @var Array<int, bool>
     */
    protected $data = [];

    /**
     * @var Mage_Core_Model_Store
     */
    protected $store;

    private function __construct(Mage_Core_Model_Store $store) {
        $this->store = $store;
    }

    public function queue(Mage_Catalog_Model_Product $product): void {
        if( ! in_array($product->getId(), $this->productIds)) {
            $this->productIds[] = $product->getId();
        }
    }

    /**
     * @return bool
     */
    public function getPointsPaymentRequired(Mage_Catalog_Model_Product $product): bool {
        if( ! empty($this->productIds)) {
            $collection = Mage::getResourceModel("catalog/product_collection");

            $collection->addStoreFilter($this->store);
            $collection->addIdFilter($this->productIds);
            $collection->addAttributeToSelect("points_payment_required");

            /**
             * @var ProductExt $item
             */
            foreach($collection as $item) {
                $productId = $item->getId();

                $this->data[$productId] = (bool)$item->getPointsPaymentRequired();
            }

            $this->productIds = [];
        }

        if(array_key_exists($product->getId(), $this->data)) {
            return $this->data[$product->getId()];
        }

        return false;
    }
}

