<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use RuntimeException;
use Mage_Customer_Model_Customer;
use Points_Core_Model_Limit_Total;

class PointsSpendingLimit {
    /**
     * @var Mage_Customer_Model_Customer
     */
    protected $customer;

    /**
     * @var string
     */
    protected $type;

    /**
     * @var Points_Core_Model_Limit_Total
     */
    protected $limit;

    /**
     * @var ?int
     */
    protected $spent = null;

    public function __construct(
        Mage_Customer_Model_Customer $customer,
        string $type,
        Points_Core_Model_Limit_Total $limit
    ) {
        $this->customer = $customer;
        $this->type = $type;
        $this->limit = $limit;
    }

    public function getSpent(): int {
        if($this->spent === null) {
            $this->spent = $this->limit->getSpentDuringLastWindow($this->customer);
        }

        return $this->spent;
    }

    public function getLimit(): int {
        $val = $this->limit->getLimit();

        if($val === null) {
            throw new RuntimeException(sprintf(
                "%s: Limit with id '%d' for currency '%s' is empty",
                __METHOD__,
                $this->limit->getId(),
                $this->limit->getType()
            ));
        }

        return (int)$val;
    }

    public function getRemaining(): int {
        return max(0, $this->getLimit() - $this->getSpent());
    }

    public function getResetsAt(): string {
        return $this->limit->getNextResetDatetime();
    }
}
