<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\Currency;
use Points\Core\Points;

class QuoteShippingPoints {
    /**
     * @var Points
     */
    protected $min;

    /**
     * @var Points
     */
    protected $max;

    /**
     * @var Points
     */
    protected $value;

    /**
     * @param array{min:Points, max:Points, value:Points} $amounts
     */
    public function __construct(
        array $amounts
    ) {
        $this->min = $amounts["min"];
        $this->max = $amounts["max"];
        $this->value = $amounts["value"];
    }

    public function getMin(): TotalInterface {
        return new QuoteItemPointsTotal(
            $this->min->getTotalExclTax(),
            $this->min->getTax()
        );
    }

    public function getMax(): TotalInterface {
        return new QuoteItemPointsTotal(
            $this->max->getTotalExclTax(),
            $this->max->getTax()
        );
    }

    public function getValue(): TotalInterface {
        return new QuoteItemPointsTotal(
            $this->value->getTotalExclTax(),
            $this->value->getTax()
        );
    }
}
