<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;

use Points\Core\Currency;
use Points\Core\Points;
use Points\Core\Extension\Quote as QuoteExt;

class QuoteSelectedShippingPoints extends QuoteShippingPoints {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param array{min:Points, max:Points, value:Points} $amounts
     * @param QuoteExt $quote
     */
    public function __construct(
        array $amounts,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($amounts);

        $this->quote = $quote;
    }

    public function getSelected(): TotalInterface {
        return new QuoteItemPointsTotal(
            (int)$this->quote->getPointsShippingPoints(),
            (int)$this->quote->getPointsShippingTaxPoints()
        );
    }
}
