<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;

use Points\Core\QuoteAddressTotal;
use Points\Core\Points;
use Points\Core\Currency;
use Points\Core\Extension\Quote as QuoteExt;

class QuoteSelectedShipping extends QuoteShipping {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param array{currency:Currency, discount:?Currency} $amounts
     * @param QuoteExt $quote
     */
    public function __construct(
        QuoteAddressTotal $total,
        array $amounts,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($total, $amounts);

        $this->quote = $quote;
    }

    public function getPoints(): ?QuoteShippingPoints {
        $parts = $this->getPointsParts();

        return $parts ? new QuoteSelectedShippingPoints($parts, $this->quote) : null;
    }

    public function getCurrency(): QuoteShippingCurrency {
        return new QuoteSelectedShippingCurrency([
            "currency" => $this->currency,
            "discount" => $this->discount,
        ], $this->getPointsParts(), $this->quote);
    }
}
