<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;

use Points\Core\Currency;
use Points\Core\Points;
use Points\Core\Extension\Quote as QuoteExt;

class QuoteSelectedDiscountPoints extends QuoteDiscountPoints {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param Array<Points> $points
     * @param QuoteExt $quote
     */
    public function __construct(
        array $points,
        float $included,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($points, $included);

        $this->quote = $quote;
    }

    public function getSelected(): TotalInterface {
        return new QuoteItemPointsTotal(
            (int)$this->quote->getPointsDiscountPoints(),
            (int)$this->quote->getPointsDiscountTaxPoints()
        );
    }
}
