<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote_Item;
use MageQL_Catalog_Model_Product_Price;
use Mage_Catalog_Model_Product;

use Points\Core\QuoteAddressTotal;
use Points\Core\Extension\QuoteItem;

class QuoteItemSelectedPoints extends QuoteItemPoints {
    public function getSelected(): TotalInterface {
        return new QuoteItemPointsTotal(
            (int)$this->item->getPointsRowPoints(),
            (int)$this->item->getPointsRowTaxPoints()
        );
    }
}
