<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Catalog_Model_Product_Price;
use MageQL_Core_Model_Context;
use Mage_Catalog_Model_Product;
use Mage_Core_Model_Store;
use Mage_Sales_Model_Quote_Item;
use Mage_Tax_Model_Config;

use Points\Core\QuoteAddressTotal;
use Points\Core\Extension\QuoteItem;

class QuoteItemSelectedCurrency extends QuoteItemCurrency {
    public function getRemaining(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): MageQL_Catalog_Model_Product_Price {
        $includesVat = $ctx->getStore()->getConfig(Mage_Tax_Model_Config::CONFIG_XML_PATH_PRICE_INCLUDES_TAX);
        $rowTotal = $this->getRowTotal($ctx->getStore());
        $pointsTotal = $this->item->getPointsRowTotal() + ($includesVat ? $this->item->getPointsRowTaxTotal() : 0);

        return new MageQL_Catalog_Model_Product_Price(
            $this->item->getProduct(),
            $rowTotal - $pointsTotal
        );
    }
}
