<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Context;

// TODO: Rename to PointsTotal
class QuoteItemPointsTotal implements TotalInterface {
    /**
     * @var int
     */
    protected $value;
    /**
     * @var int
     */
    protected $vat;

    public function __construct(
        int $value,
        int $vat
    ) {
        $this->value = $value;
        $this->vat = $vat;
    }

    public function getIncVat(
        MageQL_Core_Model_Context $ctx
    ): int {
        return $this->value + $this->vat;
    }

    public function getExVat(
        MageQL_Core_Model_Context $ctx
    ): int {
        return $this->value;
    }

    public function getVat(
        MageQL_Core_Model_Context $ctx
    ): int {
        return $this->vat;
    }
}

