<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Catalog_Model_Product_Price;
use MageQL_Core_Model_Context;
use Mage_Catalog_Model_Product;
use Mage_Core_Model_Store;
use Mage_Sales_Model_Quote_Item;
use Mage_Tax_Model_Config;

use Points\Core\QuoteAddressTotal;
use Points\Core\Extension\QuoteItem;

class QuoteItemCurrency {
    /**
     * @var QuoteItem
     */
    protected $item;

    /**
     * @var QuoteAddressTotal
     */
    protected $totals;

    /**
     * @param QuoteItem $item
     */
    public function __construct(
        QuoteAddressTotal $totals,
        Mage_Sales_Model_Quote_Item $item
    ) {
        $this->totals = $totals;
        $this->item = $item;
    }

    public function getMin(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): MageQL_Catalog_Model_Product_Price {
        $value = $this->totals->getRowPointsValue($this->item);
        $max = $this->totals->getRowPointsMax($this->item) ?: $value;

        $percent = $value && $max && $value->getTotalInclTax() > 0 ?
            min(max($value->getTotalInclTax() - $max->getTotalInclTax(), 0) / $value->getTotalInclTax(), 1) :
            0;

        return new MageQL_Catalog_Model_Product_Price(
            $this->item->getProduct(),
            $percent * $this->getRowTotal($ctx->getStore())
        );
    }

    public function getMax(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): MageQL_Catalog_Model_Product_Price {
        $value = $this->totals->getRowPointsValue($this->item);
        $min = $this->totals->getRowPointsMin($this->item) ?: $value;

        $percent = $value && $min && $value->getTotalInclTax() > 0 ?
            min(max($value->getTotalInclTax() - $min->getTotalInclTax(), 0) / $value->getTotalInclTax(), 1) :
            1;

        return new MageQL_Catalog_Model_Product_Price(
            $this->item->getProduct(),
            $percent * $this->getRowTotal($ctx->getStore())
        );
    }

    public function getValue(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): MageQL_Catalog_Model_Product_Price {
        return new MageQL_Catalog_Model_Product_Price(
            $this->item->getProduct(),
            $this->getRowTotal($ctx->getStore())
        );
    }

    protected function getRowTotal(
        Mage_Core_Model_Store $store
    ): float {
        $includesVat = $store->getConfig(Mage_Tax_Model_Config::CONFIG_XML_PATH_PRICE_INCLUDES_TAX);

        return $includesVat ? (
                $this->item->getRowTotal() +
                $this->item->getTaxAmount() +
                $this->item->getHiddenTaxAmount() -
                $this->item->getDiscountAmount()
            ) : (
                $this->item->getRowTotal() -
                $this->item->getDiscountAmount()
            );
    }
}
