<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\Currency;
use Points\Core\Points;

class QuoteDiscountPoints {
    /**
     * @var Array<Points>
     */
    protected $points;

    /**
     * @var float
     */
    protected $included;

    /**
     * @param Array<Points> $points
     */
    public function __construct(
        array $points,
        float $included
    ) {
        $this->points = $points;
        $this->included = $included;
    }

    public function getMin(): TotalInterface {
        $value = array_sum(array_map("Points\Core\Amount::totalExclTax", $this->points));
        $tax = array_sum(array_map("Points\Core\Amount::tax", $this->points));
        $rate = (1 - $this->included);

        return new QuoteItemPointsTotal(
            // TODO: Spread this?
            (int)($rate * $value),
            (int)($rate * $tax)
        );
    }

    public function getMax(): TotalInterface {
        $value = array_sum(array_map("Points\Core\Amount::totalExclTax", $this->points));
        $tax = array_sum(array_map("Points\Core\Amount::tax", $this->points));

        return new QuoteItemPointsTotal(
            (int)($this->included * $value),
            (int)($this->included * $tax)
        );
    }

    public function getValue(): TotalInterface {
        $value = array_sum(array_map("Points\Core\Amount::totalExclTax", $this->points));
        $tax = array_sum(array_map("Points\Core\Amount::tax", $this->points));

        return new QuoteItemPointsTotal(
            (int)$value,
            (int)$tax
        );
    }
}
