<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\QuoteAddressTotal;
use Points\Core\Points;
use Points\Core\Currency;

class QuoteDiscount {
    /**
     * @var Array<Currency>
     */
    protected $currency;

    /**
     * @var Array<Points>
     */
    protected $points;

    /**
     * @param Array<Currency> $currency
     * @param Array<Points> $points
     */
    public function __construct(
        array $currency,
        array $points
    ) {
        $this->currency = $currency;
        $this->points = $points;
    }

    public function getPoints(): QuoteDiscountPoints {
        $incl = array_sum(array_map("Points\Core\Amount::totalInclTax", array_filter($this->currency, "Points\Core\Currency::isIncluded")));
        $excl = array_sum(array_map("Points\Core\Amount::totalInclTax", array_filter($this->currency, "Points\Core\Currency::isNotIncluded")));

        $incRate = ($incl + $excl) > 0 ? $incl / ($incl + $excl) : 0;

        return new QuoteDiscountPoints($this->points, $incRate);
    }

    public function getCurrency(): QuoteDiscountCurrency {
        return new QuoteDiscountCurrency($this->currency);
    }
}
