<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;
use Mage_Sales_Model_Order;

use Points\Core\Extension\Order as OrderExt;

class OrderSelectedDiscount {
    /**
     * @var OrderExt
     */
    protected $order;

    /**
     * @param OrderExt $order
     */
    public function __construct(
        Mage_Sales_Model_Order $order
    ) {
        $this->order = $order;
    }

    public function getPoints(): TotalInterface {
        return new QuoteItemPointsTotal(
            (int)$this->order->getPointsDiscountPoints(),
            (int)$this->order->getPointsDiscountTaxPoints()
        );
    }

    public function getCurrency(): MageQL_Core_Model_Price_Abstract {
        $grandTotal = $this->order->getGrandTotal();
        $tax = $this->order->getTaxAmount();

        $taxRate = $grandTotal > 0 ? $tax / $grandTotal : 0;

        return new QuoteCurrencyTotal(
            abs($this->order->getDiscountAmount()) - $this->order->getPointsDiscountTotal(),
            true,
            abs($this->order->getDiscountAmount() * $taxRate) - $this->order->getPointsDiscountTaxTotal()
        );
    }
}
