<?php

declare(strict_types=1);

class Points_Core_Model_Resource_Limit_Order extends Mage_Core_Model_Resource_Db_Abstract {
    public function __construct() {
        $this->_init("points_core/limit_order", "entity_id");
    }

    protected function _construct(): void {
    }

    /**
     * @param int $customerGroupId
     */
    public function loadByStoreTypeCustomerGroupId(
        Points_Core_Model_Limit_Order $limit,
        Mage_Core_Model_Store $store,
        string $type,
        $customerGroupId
    ): void {
        $adapter = $this->_getReadAdapter();
        $bind = [
            "store_id" => $store->getId(),
            "type" => $type,
            "customer_group_id" => $customerGroupId,
        ];

        $select = $adapter->select()
            ->from($this->getTable("points_core/limit_order"), ["entity_id"])
            ->where("store_id = :store_id AND type = :type AND customer_group_id = :customer_group_id");

        $entityId = $adapter->fetchOne($select, $bind);

        if($entityId) {
            $this->load($limit, $entityId);
        }
        else {
            $limit->setData([]);
        }
    }

    /**
     * @param Array<string> $types
     * @param int $customerGroupId
     * @return Array<Points_Core_Model_Limit_Order>
     */
    public function getMatchingLimits(Mage_Core_Model_Store $store, $customerGroupId, array $types): array {
        $result = [];
        $collection = Mage::getResourceModel("points_core/limit_order_collection");
        $select = $collection->getSelect();

        $select->where("type IN (?)", $types);
        $select->where("store_id IN (0, ?)", $store->getId());
        $select->where("customer_group_id IN (?)", [Mage_Customer_Model_Group::NOT_LOGGED_IN_ID, $customerGroupId]);
        // Make sure we overwrite any 0 store with the more specific store, and take customer group into account
        $select->order(["store_id asc", "customer_group_id asc"]);

        foreach($collection as $c) {
            $result[$c->getType()] = $c;
        }

        return $result;
    }

    /**
     * @param int $customerGroupId
     */
    public function getMatchingLimit(
        Mage_Core_Model_Store $store,
        $customerGroupId,
        string $type
    ): ?Points_Core_Model_Limit_Order {
        $limits = $this->getMatchingLimits($store, $customerGroupId, [$type]);

        if(empty($limits[$type])) {
            return null;
        }

        return $limits[$type];
    }
}
