<?php

declare(strict_types=1);

/**
 * @method int getProductId()
 * @method setProductId(int $productId)
 * @method int getStoreId()
 * @method setStoreId(int $storeId)
 * @method int getCustomerGroupId()
 * @method setCustomerGroupId(int $customerGroupId)
 * @method string getType()
 * @method setType(string $type)
 * @method int getPrice()
 * @method setPrice(int $price)
 * @method int getMinPrice()
 * @method setMinPrice(int $price)
 * @method ?int getMaxPrice()
 * @method setMaxPrice(?int $price)
 * @method string getCreatedAt()
 * @method string getUpdatedAt()
 */
class Points_Core_Model_Product_Price extends Mage_Core_Model_Abstract {
    const ENTITY = "points_core_product_price";

    public function _construct(): void {
        parent::_construct();

        $this->_init("points_core/product_price");
    }

    /**
     * @param int $customerGroupId
     * @return $this
     */
    public function loadByStoreProductTypeCustomerGroupId(
        Mage_Core_Model_Store $store,
        Mage_Catalog_Model_Product $product,
        string $type,
        $customerGroupId = Mage_Customer_Model_Group::NOT_LOGGED_IN_ID
    ) {
        /**
         * @var Points_Core_Model_Resource_Product_Price
         */
        $resource = $this->_getResource();

        $resource->loadByStoreProductTypeCustomerGroupId($this, $store, $product, $type, $customerGroupId);

        return $this;
    }

    public function setStore(Mage_Core_Model_Store $store): void {
        $this->setStoreId($store->getId());
    }

    public function setProduct(Mage_Catalog_Model_Product $product): void {
        $this->setProductId($product->getId());
    }

    public function setCustomerGroup(Mage_Customer_Model_Group $group): void {
        $this->setCustomerGroupId($group->getId());
    }

    protected function _beforeSave() {
        parent::_beforeSave();

        $this->setData("updated_at", date("Y-m-d\\TG:i:s"));

        return $this;
    }

    /**
     * Init indexing process after product delete commit
     */
    protected function _afterDeleteCommit(): void {
        parent::_afterDeleteCommit();

        $indexer = Mage::getSingleton("index/indexer");

        $indexer->processEntityAction($this, self::ENTITY, Mage_Index_Model_Event::TYPE_DELETE);
    }

    public function afterCommitCallback(): void {
        parent::afterCommitCallback();

        $indexer = Mage::getSingleton('index/indexer');

        $indexer->processEntityAction($this, self::ENTITY, Mage_Index_Model_Event::TYPE_SAVE);
    }
}
