<?php

declare(strict_types=1);

class Points_Core_Model_Adminhtml_Observer extends Mage_Core_Model_Abstract {
    public function catalogProductPrepareSave(Varien_Event_Observer $observer): void {
        /**
         * @var Mage_Catalog_Model_Product
         */
        $product = $observer->getProduct();
        /**
         * @var ?Array<array{ id:?string, type:string, customer_group_id:string, price:string, min_price:string, max_price:string }>
         */
        $data = $product->getData("points_prices");
        $items = [];

        if( ! is_array($data)) {
            return;
        }

        foreach($data as $row) {
            $item = Mage::getModel("points_core/product_price");

            if( ! empty($row["id"])) {
                $item->load((int)$row["id"]);

                if($item->getProductId() != $product->getId()) {
                    $item->setData([]);
                }
            }
            else {
                $row["id"] = null;
            }

            if(empty($row["max_price"])) {
                $row["max_price"] = null;
            }

            if( ! empty($row["use_default"]) || empty($row["price"])) {
                $item->delete();

                continue;
            }

            $item->addData($row);

            $items[] = $item;
        }

        $product->setData("points_prices", $items);
    }

    public function catalogProductAfterSave(Varien_Event_Observer $observer): void {
        /**
         * @var Mage_Catalog_Model_Product
         */
        $product = $observer->getProduct();

        foreach($product->getData("points_prices") ?: [] as $item) {
            $item->setProductId($product->getId());

            $item->save();
        }
    }
}
