<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$quoteColumns = [
    "points_discount_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Number of points discounted, excluding tax",
    ],
    "points_discount_tax_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Number of points discounted on tax",
    ],
    "points_discount_value" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Value of the discount in points, excluding tax",
    ],
    "points_discount_tax_value" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Value of the discount tax in points",
    ],
    "points_discount_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the discount points cover, excluding tax",
    ],
    "points_discount_tax_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the discount points cover in tax",
    ],
    "base_points_discount_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the discount points cover, excluding tax",
    ],
    "base_points_discount_tax_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the discount points cover in tax",
    ],
];

foreach($quoteColumns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/quote_address"), $col, $spec);
    $conn->addColumn($this->getTable("sales/quote"), $col, $spec);
    $conn->addColumn($this->getTable("sales/order"), $col, $spec);
}

$installer->endSetup();
