<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$itemModifyColumns = [
    [
        "old" => "points_row_points_value",
        "new" => "points_row_value",
        "def" => [
            "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
            "nullable" => true,
            "default" => 0,
            "comment" => "Row value in points excluding tax",
        ],
    ],
    [
        "old" => "points_row_tax_points_value",
        "new" => "points_row_tax_value",
        "def" => [
            "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
            "nullable" => true,
            "default" => 0,
            "comment" => "Row value in points for tax",
        ],
    ],
];

foreach($itemModifyColumns as $col) {
    $conn->changeColumn($this->getTable("sales/quote_item"), $col["old"], $col["new"], $col["def"]);
    $conn->changeColumn($this->getTable("sales/order_item"), $col["old"], $col["new"], $col["def"]);
}

$conn->dropColumn($this->getTable("sales/quote_address"), "points_type");

$quoteModifyColumns = [
    [
        "old" => "points_points_total",
        "new" => "points_value",
        "def" => [
            "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
            "nullable" => false,
            "default" => 0,
            "comment" => "Total value for all items including shipping in points, excluding tax",
        ],
    ],
    [
        "old" => "points_tax_points_total",
        "new" => "points_tax_value",
        "def" => [
            "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
            "nullable" => false,
            "default" => 0,
            "comment" => "Total tax value for all items including shipping",
        ],
    ],
    [
        "old" => "points_shipping_points_value",
        "new" => "points_shipping_value",
        "def" => [
            "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
            "nullable" => false,
            "default" => 0,
            "comment" => "Value of the shipping in points, excluding tax",
        ],
    ],
    [
        "old" => "points_shipping_tax_points_value",
        "new" => "points_shipping_tax_value",
        "def" => [
            "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
            "nullable" => false,
            "default" => 0,
            "comment" => "Value of the shipping tax in points",
        ],
    ],
];

foreach($quoteModifyColumns as $col) {
    $conn->changeColumn($this->getTable("sales/quote_address"), $col["old"], $col["new"], $col["def"]);
    $conn->changeColumn($this->getTable("sales/quote"), $col["old"], $col["new"], $col["def"]);
    $conn->changeColumn($this->getTable("sales/order"), $col["old"], $col["new"], $col["def"]);
}

$installer->endSetup();
