<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$itemColumns = [
    [
        "old" => "points_points",
        "new" => "points_row_points_value",
        "def" => [
            "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
            "nullable" => true,
            "comment" => "Row value in points excluding tax, in the selected point type",
        ],
    ],
    [
        "old" => "points_tax_points",
        "new" => "points_row_tax_points_value",
        "def" => [
            "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
            "nullable" => true,
            "comment" => "Row value in points for tax, in the selected point type",
        ],
    ],
];

foreach($itemColumns as $col) {
    $conn->changeColumn($this->getTable("sales/quote_item"), $col["old"], $col["new"], $col["def"]);
    $conn->changeColumn($this->getTable("sales/order_item"), $col["old"], $col["new"], $col["def"]);
}

$installer->endSetup();
