<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$quoteColumns = [
    "points_points_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Value of the quote/order in points excluding tax",
    ],
    "points_tax_points_total" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Tax value of the quote/order in points",
    ],
    "points_amount_included" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency included in the points calculation, excluding tax value",
    ],
    "points_tax_amount_included" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency included in the points calculation, tax",
    ],
    "points_amount_excluded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency excluded from the points calculation, excluding tax value",
    ],
    "points_tax_amount_excluded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency excluded from the points calculation, tax",
    ],
];

$itemColumns = [
    "points_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => true,
        "comment" => "Amount of points excluding tax, in the selected point type",
    ],
    "points_tax_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => true,
        "comment" => "Amount of points for tax, in the selected point type",
    ],
];

$quoteItemColumnsDelete = [
    "points_base_row_total",
    "points_base_row_tax",
    "points_row_total",
    "points_row_tax",
];

foreach($quoteColumns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/quote"), $col, $spec);
    $conn->addColumn($this->getTable("sales/quote_address"), $col, $spec);
    $conn->addColumn($this->getTable("sales/order"), $col, $spec);
}

foreach($itemColumns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/order_item"), $col, $spec);
}

foreach($itemColumns as $col => $spec) {
    $conn->modifyColumn($this->getTable("sales/quote_item"), $col, $spec);
}

foreach($quoteItemColumnsDelete as $col) {
    $conn->dropColumn($this->getTable("sales/quote_item"), $col);
}

$installer->endSetup();
