<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$totalLimitsTable = $conn->newTable($installer->getTable("points_core/limit_total"));

$totalLimitsTable->addColumn("entity_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "identity" => true,
    "unsigned" => true,
    "nullable" => false,
    "primary" => true,
], "Point limit row entity id");
$totalLimitsTable->addColumn("store_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "unsigned" => true,
    "nullable" => false,
], "Store Id");
$totalLimitsTable->addColumn("customer_group_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "unsigned" => true,
    "nullable" => false,
], "Store Id");
$totalLimitsTable->addColumn("type", Varien_Db_Ddl_Table::TYPE_TEXT, 64, [
    "nullable" => false,
], "Point type code");
$totalLimitsTable->addColumn("time_interval", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
    "nullable" => false,
], "Time interval, constant from Points_Core_Model_Limit");
$totalLimitsTable->addColumn("limit", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "unsigned" => true,
    "nullable" => true,
]);
$totalLimitsTable->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
], "Created at");
$totalLimitsTable->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
], "Updated at");

$totalLimitsTable->addIndex(
    $installer->getIdxName("points_core/limit_total", ["store_id", "customer_group_id", "type"], Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE),
    ["store_id", "customer_group_id", "type"],
    ["type" => Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE]
);

$totalLimitsTable->addForeignKey(
    $installer->getFkName("points_core/limit_total", "store_id", "core/store", "store_id"),
    "store_id",
    $installer->getTable("core/store"),
    "store_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE,
    Varien_Db_Ddl_Table::ACTION_CASCADE
);

$totalLimitsTable->setOption("type", "InnoDB");
$totalLimitsTable->setOption("charset", "utf8");

$conn->createTable($totalLimitsTable);

$orderLimitsTable = $conn->newTable($installer->getTable("points_core/limit_order"));

$orderLimitsTable->addColumn("entity_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "identity" => true,
    "unsigned" => true,
    "nullable" => false,
    "primary" => true,
], "Point limit row entity id");
$orderLimitsTable->addColumn("store_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "unsigned" => true,
    "nullable" => false,
], "Store Id");
$orderLimitsTable->addColumn("customer_group_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
    "unsigned" => true,
    "nullable" => false,
], "Store Id");
$orderLimitsTable->addColumn("type", Varien_Db_Ddl_Table::TYPE_TEXT, 64, [
    "nullable" => false,
], "Point type code");
$orderLimitsTable->addColumn("min_value", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "unsigned" => true,
    "nullable" => false,
    "default" => 0,
]);
$orderLimitsTable->addColumn("min_percent", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "unsigned" => true,
    "nullable" => false,
    "default" => 0,
]);
$orderLimitsTable->addColumn("max_value", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "unsigned" => true,
    "nullable" => true,
    "default" => 0,
]);
$orderLimitsTable->addColumn("max_percent", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
    "unsigned" => true,
    "nullable" => true,
    "default" => 0,
]);
$orderLimitsTable->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
], "Created at");
$orderLimitsTable->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
    "nullable" => false,
    "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
], "Updated at");

$orderLimitsTable->addIndex(
    $installer->getIdxName("points_core/limit_order", ["store_id", "customer_group_id", "type"], Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE),
    ["store_id", "customer_group_id", "type"],
    ["type" => Varien_Db_Adapter_Interface::INDEX_TYPE_UNIQUE]
);

$orderLimitsTable->addForeignKey(
    $installer->getFkName("points_core/limit_order", "store_id", "core/store", "store_id"),
    "store_id",
    $installer->getTable("core/store"),
    "store_id",
    Varien_Db_Ddl_Table::ACTION_CASCADE,
    Varien_Db_Ddl_Table::ACTION_CASCADE
);

$orderLimitsTable->setOption("type", "InnoDB");
$orderLimitsTable->setOption("charset", "utf8");

$conn->createTable($orderLimitsTable);

$columns = [
    "points_type" => [
        "type" => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length" => 64,
        "nullable" => true,
        "comment" => "The points currency type code used, if any",
    ],
    "points_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points to spend on this quote excluding tax",
    ],
    "points_tax_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points to spend on this quote for tax",
    ],
    "base_points_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover, excluding tax value",
    ],
    "base_points_tax_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover of the tax value",
    ],
    "points_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
    "points_tax_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
];

foreach($columns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/order"), $col, $spec);
}

$installer->endSetup();
