
```graphql
extends Quote {
  availablePointPayments: [QuotePointPayment!]!
  points: QuotePoints,
}

type QuotePointPayment {
  """Id of the currency type"""
  id: ID!,
  """Name of the currency type"""
  label: String!,
  """Minimum amount of points to spend"""
  minimum: Price!,
  """Maximum amount of points available to spend"""
  maximum: Price!,
  """Quote value in points"""
  quoteValue: Price!,
}

type QuotePoints {
  """Id of the currency type"""
  id: ID!,
  """Name of the currency type"""
  label: String!,
  """Current amount of points to spend in this currency"""
  points: Price!,
  """Points value in the quote currency"""
  priceEquivalent: Price!,
}
```

## Magento totals calculation

### Standard

Totals:

* ~~Nominal~~

  Before: Subtotal

  All of the following is for recurring products only and are calculated separately.
  Recurring items are nominal, non-recurring are non-nominal.

  * Recurring Initial Fee
  * Recurring Trial Payment
  * Nominal Subtotal

    Saved in `row_total` per row for all nominal items, only applied for recurring items.

  * Nominal Shipping

  ```
  item.rowTotal = SUM(item.nominalTotals t WHERE t.isTotalCompoundable)
  ```
 
* Subtotal

  After: Nominal
  Before: Grand Total

  Original logic:

  ```
  item.price = product.getFinalPrice
  item.row_total = item.total_qty * item.price
  // or:
  item.row_total = item.total_qty * item.calculation_price_original

  address.totals.subtotal = SUM(item.row_total)
  address.virtual_amount = SUM(item.row_total where item.is_virtual)
  ```


* MSRP

  Before: Grand Total

  Sets a boolean on address if MSRP can be used.

* Freeshipping

  Before: Tax Subtotal, Shipping
  After: Subtotal

  Iterates all items and determines if the quote is eligible for freeshipping.

* Shipping

  After: Subtotal, Freeshipping, Tax Subtotal, MSRP
  Before: Grand Total

  Iterates all items and sets shipping.

  ```
  address.totals.shipping = rate.amount
  ```

* Tax Subtotal

  After: Subtotal, Nominal, Shipping, Freeshipping
  Before: Tax, Discount

  ```
  for i in items:
    item.row_tax = tax * qty
    item.price
    item.row_total
    item.price_incl_tax
    item.row_total_incl_tax
    item.taxable_amount
    item.is_price_incl_tax
    
    address.totals.subtotal += item.row_total
    address.subtotal_incl_tax += item.row_total_incl_tax
  ```

  Do we need to take rounding deltas into account?

* Tax Shipping

  After: Shipping, Tax Subtotal
  Before: Tax, Discount

  ```
  address.totals.shipping = address.totals.shipping
  // or, depending on config
  address.totals.shipping = address.totals.shipping - tax(address.totals.shipping)
  // as well as the incl_tax values and is_shipping_incl_tax
  ```

* Tax

  After: Subtotal, Shipping
  Before: Grand Total

  ```
  address.applied_taxes

  address.totals.tax = 0

  for i in items:
    item.tax_amount = tax(item.price)
    item.hidden_tax_amount = 0 // mostly
    item.tax_percent
    address.applied_taxes[item.tax_percent] += item.tax_amount
    address.totals.tax += item.tax_amount
  address.totals.tax += extra_tax_amount
  address.totals.shipping_tax_amount = tax(address.totals.shipping)
  ```

* ~~WEEE tax~~

  Unused

  After: Subtotal, Tax Subtotal
  Before: Shipping, Tax, Discount

* Discount

  After: Subtotal, Shipping
  Before: Grand Total

  ```
  address.totals.discount = discount
  address.grand_total -= discount
  ```

* Grand Total

  After: Subtotal

  ```
  address.grand_total = SUM(address.totals) + address.grand_total
  ```

Similar is done with base currency variants.

```
quote.subtotal = SUM(address.subtotal)
quote.grand_total = SUM(address.grand_total)
```

### Rounding

1. First list exvat and vat values in a table.
2. For exvat, vat do:
  1. Summarize the values and round up the result
  2. Calculate the error by taking the previous sum and subtracting the sum of all values rounded down
  3. Sort the values by the error caused by rounding up with the lowest error fist
  4. Walk through this list rounding up as long as there is remaining total error, these are the new values
2. Summarize per column and row
