<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;

use Points\Core\Currency;

class QuoteDiscountCurrency {
    /**
     * @var Array<Currency>
     */
    protected $currency;

    /**
     * @param Array<Currency> $currency
     */
    public function __construct(
        array $currency
    ) {
        $this->currency = $currency;
    }

    public function getMin(): MageQL_Core_Model_Price_Abstract {
        $excluded = array_filter($this->currency, "Points\Core\Currency::isNotIncluded");

        return new QuoteCurrencyTotal(
            array_sum(array_map("Points\Core\Amount::totalInclTax", $excluded)),
            true,
            array_sum(array_map("Points\Core\Amount::tax", $excluded))
        );
    }

    public function getMax(): MageQL_Core_Model_Price_Abstract {
        $included = array_filter($this->currency, "Points\Core\Currency::isIncluded");

        return new QuoteCurrencyTotal(
            array_sum(array_map("Points\Core\Amount::totalInclTax", $included)),
            true,
            array_sum(array_map("Points\Core\Amount::tax", $included))
        );
    }

    public function getValue(): MageQL_Core_Model_Price_Abstract {
        return new QuoteCurrencyTotal(
            abs(array_sum(array_map("Points\Core\Amount::totalInclTax", $this->currency))),
            true,
            abs(array_sum(array_map("Points\Core\Amount::tax", $this->currency)))
        );
    }
}
