<?php

declare(strict_types=1);

namespace Points\Core;

/**
 * @extends Amount<float>
 */
class Currency extends Amount {
    /**
     * @var bool
     */
    protected $included;

    public function __construct(float $value, bool $valueIncludesTax, float $tax, bool $included) {
        parent::__construct($value, $valueIncludesTax, $tax);

        $this->included = $included;
    }

    public function getIncluded(): bool {
        return $this->included;
    }

    public static function isIncluded(Currency $currency): bool {
        return $currency->getIncluded();
    }

    public static function isNotIncluded(Currency $currency): bool {
        return ! $currency->getIncluded();
    }
}
