<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote_Item;
use MageQL\Context;
use Points\Core\ProviderInterface;
use Points\Core\Total\Item;

class QuoteItem {
    /**
     * @var string
     */
    protected $type;

    /**
     * @var ProviderInterface
     */
    protected $provider;

    /**
     * @var Item<int>
     */
    protected $totals;

    /**
     * @var Mage_Sales_Model_Quote_Item $item
     */
    protected $item;

    /**
     * @param Item<int> $totals
     */
    public function __construct(
        string $type,
        ProviderInterface $provider,
        Item $totals,
        Mage_Sales_Model_Quote_Item $item
    ) {
        $this->type = $type;
        $this->provider = $provider;
        $this->totals = $totals;
        $this->item = $item;
    }

    public function getId(): string {
        return $this->type;
    }

    public function getLabel(
        array $args,
        Context $ctx
    ): string {
        return $this->provider->getLabel($ctx->getStore());
    }

    public function getCurrencyRequired(): bool {
        $points = $this->totals->getPoints();

        if( ! $points) {
            return true;
        }

        $value = $points->getValue()->getTotalInclTax();
        $max = $points->getMax()->getTotalInclTax();

        return $max < $value;
    }

    public function getPoints(): QuoteItemPoints {
        return new QuoteItemPoints($this->totals);
    }

    public function getCurrency(): QuoteItemCurrency {
        return new QuoteItemCurrency($this->totals, $this->item);
    }
}
