<?php

class Points_Core_Block_Points_Config_Edit_Tab_TotalLimits
    extends Points_Core_Block_Points_Config_Edit_Tab_Abstract
{
    public function __construct()
    {
        parent::__construct();
        $this->setTemplate('points_core/config/total_limits.phtml');
    }

    // Collect and link data from total limit, apply default values
    public function getBaseValues(string $storeId): array
    {
        $helper = Mage::helper('points_core');
        $store = Mage::app()->getStore($storeId);
        $data = [];

        // Row per provider, default values
        foreach ($helper->getTypeProviders() as $type => $provider) {
            $data[$type] = [
                // General
                'type' => $type,
                'label' => $provider->getLabel($store) ?: $type,
                'store_id' => $store->getId(),
                'customer_group_id' => Mage_Customer_Model_Group::NOT_LOGGED_IN_ID,
                'total' => [
                    'id' => null,
                    'time_interval' => Points_Core_Model_Limit_Total::INTERVAL_WEEK,
                    'limit' => null,
                    'includes_tax' => false,
                    'use_default' => $store->getId() != Mage_Core_Model_App::ADMIN_STORE_ID,
                ],
            ];
        }

        // Get and patch total limit
        $collection = Mage::getResourceModel('points_core/limit_total_collection');
        $collection->getSelect()->where("store_id IN (0, ?)", (int)$store->getId());
        $collection->getSelect()->order(["store_id ASC"]);
        $collection->filterByNotLoggedInCustomerGroup();
        foreach ($collection as $item) {
            $type = $item->getType();
            if (!array_key_exists($type, $data)) {
                continue;
            }
            $data[$type]['total'] = array_merge($data[$type]['total'], [
                'id' => $item->getStoreId() == $store->getId() ? $item->getId() : null,
                'time_interval' => $item->getTimeInterval(),
                'limit' => $item->getLimit(),
                'includes_tax' => $item->getIncludesTax(),
                'use_default' => $item->getStoreId() != $store->getId(),
            ]);
        }
        return array_values($data);
    }

    public function getTabLabel(): string
    {
        return Mage::helper('points_core')->__('Total limits');
    }

    public function getTabTitle(): string
    {
        return Mage::helper('points_core')->__('Total limits');
    }
}
