<?php

declare(strict_types=1);

namespace Points\Core\Total;

use Mage_Tax_Model_Config;
use Points_Core_Model_Product_Price;
use Points\Core\Points;
use Points\Core\Amount;

class SelectedPoints implements PointsInterface {
    /**
     * @var PointsInterface
     */
    private $points;
    /**
     * @var Amount<int>
     */
    private $selected;

    /**
     * @param PointsInterface $points
     * @param Amount<int> $selected
     */
    public function __construct($points, $selected) {
        $this->points = $points;
        $this->selected = $selected;
    }

    public function getValue(): Amount {
        return $this->points->getValue();
    }

    public function getMin(): Amount {
        return $this->points->getMin();
    }

    public function getMax(): Amount {
        return $this->points->getMax();
    }

    public function getDiscount(): Amount {
        return $this->points->getDiscount();
    }

    /**
     * The amount of points to spend on this item.
     *
     * @return Amount<int>
     */
    public function getSelected(): Amount {
        return $this->selected;
    }
}
