<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Catalog_Model_Product_Price;
use MageQL_Core_Model_Context;
use Mage_Catalog_Model_Product;
use Mage_Core_Model_Store;
use Mage_Sales_Model_Quote_Item;
use Mage_Tax_Model_Config;

use Points\Core\Total\Item;

class QuoteItemCurrency {
    /**
     * @var Mage_Sales_Model_Quote_Item
     */
    protected $item;

    /**
     * @var Item<int>
     */
    protected $totals;

    /**
     * @param Item<int> $totals
     */
    public function __construct(
        Item $totals,
        Mage_Sales_Model_Quote_Item $item
    ) {
        $this->totals = $totals;
        $this->item = $item;
    }

    public function getMin(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): MageQL_Catalog_Model_Product_Price {
        $points = $this->totals->getPoints();

        assert($points !== null);

        $value = $points->getValue()->getTotalInclTax();
        $max = $points->getMax()->getTotalInclTax();

        $percent = $value > 0 ? min(max($value - $max, 0) / $value, 1) : 0;

        return new MageQL_Catalog_Model_Product_Price(
            $this->item->getProduct(),
            $percent * $this->getRowTotal($ctx->getStore())
        );
    }

    public function getMax(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): MageQL_Catalog_Model_Product_Price {
        $points = $this->totals->getPoints();

        assert($points !== null);

        $value = $points->getValue()->getTotalInclTax();
        $min = $points->getMin()->getTotalInclTax();

        $percent = $value > 0 ? min(max($value - $min, 0) / $value, 1) : 1;

        return new MageQL_Catalog_Model_Product_Price(
            $this->item->getProduct(),
            $percent * $this->getRowTotal($ctx->getStore())
        );
    }

    public function getValue(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): MageQL_Catalog_Model_Product_Price {
        return new MageQL_Catalog_Model_Product_Price(
            $this->item->getProduct(),
            $this->getRowTotal($ctx->getStore())
        );
    }

    protected function getRowTotal(
        Mage_Core_Model_Store $store
    ): float {
        $includesVat = $store->getConfig(Mage_Tax_Model_Config::CONFIG_XML_PATH_PRICE_INCLUDES_TAX);

        return $includesVat ? (
                $this->item->getRowTotal() +
                $this->item->getTaxAmount() +
                $this->item->getHiddenTaxAmount() -
                $this->item->getDiscountAmount()
            ) : (
                $this->item->getRowTotal() -
                $this->item->getDiscountAmount()
            );
    }
}
