<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$tables = [
    $this->getTable("sales/creditmemo"),
    $this->getTable("sales/invoice"),
];

$columns = [
    "points_type" => [
        "type" => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length" => 64,
        "nullable" => true,
        "comment" => "The points currency type code used, if any",
    ],
    "points_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points excluding tax",
    ],
    "points_tax_points" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points for tax",
    ],
    "base_points_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover, excluding tax value",
    ],
    "base_points_tax_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover of the tax value",
    ],
    "points_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
    "points_tax_amount" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
];

foreach($columns as $col => $spec) {
    foreach($tables as $t) {
        $conn->addColumn($t, $col, $spec);
    }
}

$orderColumns = [
    "points_points_invoiced" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points excluding tax",
    ],
    "points_tax_points_invoiced" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points for tax",
    ],
    "base_points_amount_invoiced" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover, excluding tax value",
    ],
    "base_points_tax_amount_invoiced" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover of the tax value",
    ],
    "points_amount_invoiced" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
    "points_tax_amount_invoiced" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
    "points_points_refunded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points excluding tax",
    ],
    "points_tax_points_refunded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_INTEGER,
        "nullable" => false,
        "default" => 0,
        "comment" => "Amount of points for tax",
    ],
    "base_points_amount_refunded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover, excluding tax value",
    ],
    "base_points_tax_amount_refunded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of base currency the points cover of the tax value",
    ],
    "points_amount_refunded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
    "points_tax_amount_refunded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the points cover in tax",
    ],
];

foreach($orderColumns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/order"), $col, $spec);
}

$installer->endSetup();
