<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage;
use MageQL_Core_Model_Context;
use Mage_Customer_Model_Group;

use Points\Core\ProviderInterface;

class PointsType {
    /**
     * @var string
     */
    protected $type;
    /**
     * @var ProviderInterface
     */
    protected $provider;

    public function __construct(
        string $type,
        ProviderInterface $provider
    ) {
        $this->type = $type;
        $this->provider = $provider;
    }

    public function getId(): string {
        return $this->type;
    }

    public function getLabel(array $unusedArgs, MageQL_Core_Model_Context $ctx): string {
        return $this->provider->getLabel($ctx->getStore());
    }

    public function getOrderSpendingLimits(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): PointsTypeOrderLimits {
        $resource = Mage::getResourceModel("points_core/limit_order");

        // Just load the global setting, no customer group id involved here
        $limits = $resource->getMatchingLimits(
            $ctx->getStore(),
            Mage_Customer_Model_Group::NOT_LOGGED_IN_ID,
            [$this->type]
        );

        return new PointsTypeOrderLimits($limits[$this->type] ?? null);
    }
}
