<?php

declare(strict_types=1);

class Points_Core_Model_Adminhtml_Observer extends Mage_Core_Model_Abstract {
    public function catalogProductPrepareSave(Varien_Event_Observer $observer): void {
        /**
         * @var Mage_Catalog_Model_Product
         */
        $product = $observer->getProduct();
        /**
         * @var ?Array<array{ id:?string, type:string, customer_group_id:string, price:string, min_price:string, max_price:string }>
         */
        $data = $product->getData("points_prices");
        $items = [];

        if( ! is_array($data)) {
            return;
        }

        foreach($data as $row) {
            $item = Mage::getModel("points_core/product_price");

            if( ! empty($row["id"])) {
                $item->load((int)$row["id"]);

                if($item->getProductId() != $product->getId()) {
                    $item->setData([]);
                }
            }
            else {
                $row["id"] = null;
            }

            if(empty($row["max_price"])) {
                $row["max_price"] = null;
            }

            if( ! empty($row["use_default"]) || empty($row["price"])) {
                $item->delete();

                continue;
            }

            $item->addData($row);

            $items[] = $item;
        }

        $product->setData("points_prices", $items);
    }

    public function catalogProductAfterSave(Varien_Event_Observer $observer): void {
        /**
         * @var Mage_Catalog_Model_Product
         */
        $product = $observer->getProduct();

        foreach($product->getData("points_prices") ?: [] as $item) {
            $item->setProductId($product->getId());

            $item->save();
        }
    }

    public function catalogProductActionAfterSave(Varien_Event_Observer $observer): void
    {
        $product_ids = Mage::helper('adminhtml/catalog_product_edit_action_attribute')->getProductIds();
        $request_data = $observer->getControllerAction()->getRequest()->getParam('points_prices', []);
        $store = Mage::app()->getStore($observer->getControllerAction()->getRequest()->getParam('store', 0));

        if (empty($product_ids) || empty($request_data)) {
            return;
        }

        $providers = Mage::helper('points_core')->getTypeProviders();
        $session = Mage::getSingleton('adminhtml/session');
        $product = Mage::getModel('catalog/product');
        $price = Mage::getModel('points_core/product_price');

        foreach ($request_data as $provider_key => $prices) {
            // Verify provider
            if (!array_key_exists($provider_key, $providers)) {
                unset($request_data[$provider_key]);
                $session->addError("No points provider {$provider_key}");
                continue;
            }
            // Verify prices
            foreach ($prices as $type => $amount) {
                if (!in_array($type, ['price', 'min_price', 'max_price'])) {
                    unset($prices[$type]);
                    $session->addError("Points price type must be price, min_price or max_price, {$type} provided");
                    continue;
                }
                if ($type == 'max_price' && $amount === '') {
                    $prices[$type] = null;
                    continue;
                }
                if (!is_numeric($amount) || $amount < 0) {
                    unset($prices[$type]);
                    $session->addError("Points price amount must be >= 0, {$amount} provided");
                    continue;
                }
                $prices[$type] = floatval($amount);
            }
            if (empty($prices)) {
                continue;
            }
            // Insert or update points products for selected product id:s
            foreach ($product_ids as $product_id) {
                $product->load($product_id);
                $price->loadByStoreProductTypeCustomerGroupId($store, $product, $provider_key);
                if (empty($price->getId())) {
                    $price->setStore($store);
                    $price->setProduct($product);
                    $price->setType($provider_key);
                }
                foreach ($prices as $type => $amount) {
                    $price->setData($type, $amount);
                }
                $price->save();
            }
        }
    }
}
