<?php

class Points_Core_Block_Points_Config_Edit_Tab_OrderLimits
    extends Points_Core_Block_Points_Config_Edit_Tab_Abstract
{
    public function __construct()
    {
        parent::__construct();
        $this->setTemplate('points_core/config/order_limits.phtml');
    }

    // Collect and link data for order limits, apply default values
    public function getBaseValues(string $storeId): array
    {
        $helper = Mage::helper('points_core');
        $store = Mage::app()->getStore($storeId);

        // Row per provider, default values
        foreach ($helper->getTypeProviders() as $type => $provider) {
            $data[$type] = [
                // General
                'type' => $type,
                'label' => $provider->getLabel($store) ?: $type,
                'store_id' => $store->getId(),
                'customer_group_id' => Mage_Customer_Model_Group::NOT_LOGGED_IN_ID,
                'order' => [
                    'id' => null,
                    'min_value' =>  0,
                    'min_percent' => 0,
                    'max_value' => null,
                    'max_percent' => null,
                    'includes_tax' => false,
                    'use_default' => true,
                ],
            ];
        }

        // Get and patch order limit
        $collection = Mage::getResourceModel('points_core/limit_order_collection');
        $collection->getSelect()->where("store_id IN (0, ?)", (int)$store->getId());
        $collection->getSelect()->order(["store_id ASC"]);
        $collection->filterByNotLoggedInCustomerGroup();
        foreach ($collection as $item) {
            if (!array_key_exists($item->getType(), $data)) {
                continue;
            }
            $data[$type]['order'] = array_merge($data[$type]['order'], [
                'id' => $item->getStoreId() == $store->getId() ? $item->getId() : null,
                'min_value' => $item->getMinValue(),
                'min_percent' => $item->getMinPercent(),
                'max_value' => $item->getMaxValue(),
                'max_percent' => $item->getMaxPercent(),
                'includes_tax' => $item->getIncludesTax(),
                'use_default' => $item->getStoreId() != $store->getId(),
            ]);
        }

        return array_values($data);
    }

    public function getTabLabel(): string
    {
        return Mage::helper('points_core')->__('Order limits');
    }

    public function getTabTitle(): string
    {
        return Mage::helper('points_core')->__('Order limits');
    }
}
