<?php

namespace Points\Core;

use GraphQL\Type\Definition\Type;
use GraphQL\Type\Definition\UnionType;
use MageQL\Type\AbstractBuilder;
use MageQL\Registry;

// TODO: Replace with actual UnionBuilder when MageQL has one
class UnionBuilder extends AbstractBuilder {
    /**
    * @var Array<string>
    */
    protected $types = [];

    /**
    * @var callable
    */
    protected $resolveType;

    public function __construct(string $description, array $types, callable $resolveType) {
        parent::__construct($description);

        $this->types = $types;
        $this->resolveType = $resolveType;
    }

    public function createInstance(Registry $registry, string $typeName): Type {
        return new UnionType([
            "resolveType" =>  $this->resolveType,
            "name" => $typeName,
            "description" => $this->description,
            "types" => function () use($registry) {
                $types = [];

                foreach($this->types as $name) {
                    $types[] = $registry->getType($name);
                }

                return $types;
            },
        ]);
    }
}
