<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Core_Model_Store;
use MageQL_Core_Model_Price_Abstract;
use Points\Core\Amount;

class CurrencyTotal extends MageQL_Core_Model_Price_Abstract {
    /**
     * @var Amount<float>
     */
    protected $amount;

    /**
     * @param Amount<float> $amount
     */
    public function __construct(Amount $amount) {
        $this->amount = $amount;
    }

    public function getIncVat(Mage_Core_Model_Store $store): float {
        return $store->roundPrice($this->amount->getTotalInclTax());
    }

    public function getExVat(Mage_Core_Model_Store $store): float {
        return $store->roundPrice($this->amount->getTotalExclTax());
    }

    public function getVat(Mage_Core_Model_Store $store): float {
        return $store->roundPrice($this->amount->getTax());
    }
}
