<?php

class Points_Core_Model_Product_Price_Collector {
    private static function getRegistryKey(Mage_Core_Model_Store $store, int $customerGroupId): string {
        return sprintf("points_core_product_price_collector_%d_%d", $store->getId(), $customerGroupId);
    }

    public static function instance(Mage_Core_Model_Store $store, int $customerGroupId): self {
        $key = self::getRegistryKey($store, $customerGroupId);
        $instance = Mage::registry($key);

        if( ! $instance) {
            $instance = new self($store, $customerGroupId);

            Mage::register($key, $instance);
        }

        return $instance;
    }

    /**
     * @var Array<int>
     */
    protected $productIds = [];

    /**
     * @var Array<int, Array<Points_Core_Model_Product_Index>>
     */
    protected $data = [];

    /**
     * @var Mage_Core_Model_Store
     */
    protected $store;

    /**
     * @var int
     */
    protected $customerGroupId;

    private function __construct(Mage_Core_Model_Store $store, int $customerGroupId) {
        $this->store = $store;
        $this->customerGroupId = $customerGroupId;
    }

    public function queue(Mage_Catalog_Model_Product $product): void {
        $productId = $product->getId();

        assert($productId !== null);

        if( ! in_array($productId, $this->productIds)) {
            $this->productIds[] = $productId;
        }
    }

    /**
     * @return Array<Points_Core_Model_Product_Price_Item>
     */
    public function getPrices(Mage_Catalog_Model_Product $product): array {
        if( ! empty($this->productIds)) {
            $helper = Mage::helper("points_core");

            // TODO: Valid currencies too

            $providers = $helper->getEnabledTypeProviders($this->store);

            $indexedCollection = Mage::getResourceModel("points_core/product_index_collection");

            $indexedCollection->filterByStore($this->store);
            $indexedCollection->filterByCustomerGroupId($this->customerGroupId);
            $indexedCollection->filterByTypes(array_keys($providers));
            $indexedCollection->filterByProductIds($this->productIds);

            foreach($indexedCollection as $price) {
                $productId = $price->getProductId();

                if(empty($this->data[$productId])) {
                    $this->data[$productId] = [];
                }

                $this->data[$productId][] = $price;
            }

            $this->productIds = [];
        }

        $productId = $product->getId();

        assert($productId !== null);

        if(array_key_exists($productId, $this->data)) {
            return array_map(function($data) use($product): Points_Core_Model_Product_Price_Item {
                return new Points_Core_Model_Product_Price_Item($product, $data);
            }, $this->data[$productId]);
        }

        return [];
    }
}

