<?php

/**
 * @psalm-scope-this Mage_Customer_Model_Entity_Setup
 */
$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$quoteColumns = [
    "points_discount_total_excluded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the discount points value do not cover, excluding tax",
    ],
    "points_discount_tax_total_excluded" => [
        "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
        "nullable" => false,
        "precision" => 10,
        "scale" => 2,
        "default" => 0,
        "comment" => "Amount of currency the discount points value do not cover, excluding tax",
    ],
];

foreach($quoteColumns as $col => $spec) {
    $conn->addColumn($this->getTable("sales/quote_address"), $col, $spec);
    $conn->addColumn($this->getTable("sales/quote"), $col, $spec);
    $conn->addColumn($this->getTable("sales/order"), $col, $spec);
}

$installer->endSetup();
