<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;

use Points\Core\Points;
use Points\Core\Currency;

class QuoteShippingCurrency {
    /**
     * @var ?array{min:Points, max:Points, value:Points}
     */
    protected $points;

    /**
     * @var Currency
     */
    protected $currency;

    /**
     * @param array{currency:Currency} $amounts
     * @param ?array{min:Points, max:Points, value:Points} $points
     */
    public function __construct(
        array $amounts,
        array $points = null
    ) {
        $this->currency = $amounts["currency"];
        $this->points = $points;
    }

    public function getMin(): MageQL_Core_Model_Price_Abstract {
        $included = $this->currency->getIncluded();

        return new QuoteCurrencyTotal(
            $included ? 0 : $this->currency->getValue(),
            $this->currency->getValueIncludesTax(),
            $included ? 0 : $this->currency->getTax()
        );
    }

    public function getMax(): MageQL_Core_Model_Price_Abstract {
        return new QuoteCurrencyTotal(
            $this->currency->getValue(),
            $this->currency->getValueIncludesTax(),
            $this->currency->getTax()
        );
    }

    public function getValue(): MageQL_Core_Model_Price_Abstract {
        return new QuoteCurrencyTotal(
            $this->currency->getValue(),
            $this->currency->getValueIncludesTax(),
            $this->currency->getTax()
        );
    }
}
