<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Price_Abstract;
use Mage_Sales_Model_Quote;
use Mage_Sales_Model_Quote_Address;

use Points\Core\Currency;
use Points\Core\Extension\Quote as QuoteExt;

class QuoteSelectedDiscountCurrency extends QuoteDiscountCurrency {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param Array<Currency> $currency
     * @param QuoteExt $quote
     */
    public function __construct(
        array $currency,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($currency);

        $this->quote = $quote;
    }

    public function getRemaining(): MageQL_Core_Model_Price_Abstract {
        $totals = $this->quote->getTotals();

        $totalDiscount = abs(array_key_exists("discount", $totals) ? (double) $totals["discount"]->getValue() : 0);
        // Discounts are negative
        $pointsDiscount = -($this->quote->getPointsDiscountTotal() + $this->quote->getPointsDiscountTaxTotal());
        $grandTotal = $this->quote->getGrandTotal() + $totalDiscount;

        $tax = array_sum(array_map(function(Mage_Sales_Model_Quote_Address $a): float {
            return (float)$a->getTaxAmount() + $a->getHiddenTaxAmount();
        }, $this->quote->getAddressesCollection()->getItems()));
        $taxRate = $grandTotal > 0 ? $tax / $grandTotal : 0;

        $currencyDiscount = $totalDiscount + $pointsDiscount;

        return new QuoteCurrencyTotal(
            $currencyDiscount * (1 - $taxRate),
            false,
            $currencyDiscount * $taxRate
        );
    }
}
