<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Core_Model_Context;
use Mage_Tax_Model_Config;

use MageQL_Core_Model_Price_Abstract;
use Mage_Sales_Model_Quote;

use Points\Core\Extension\Quote as QuoteExt;
use Points\Core\QuoteAddressTotal;

class QuoteSelectedCurrency extends QuoteCurrency {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param Array<QuoteAddressTotal> $totals
     * @param QuoteExt $quote
     */
    public function __construct(
        array $totals,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($totals);

        $this->quote = $quote;
    }

    public function getRemaining(): MageQL_Core_Model_Price_Abstract {
        $tax = 0.0;

        foreach($this->quote->getAddressesCollection() as $addr) {
            $tax += (float)$addr->getTaxAmount();
        }

        return new QuoteCurrencyTotal(
            (float)$this->quote->getGrandTotal(),
            true,
            $tax
        );
    }
}
