<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote;
use MageQL_Core_Model_Price_Abstract;

use Points\Core\Points;
use Points\Core\Currency;
use Points\Core\Extension\Quote as QuoteExt;
use Points\Core\Extension\QuoteAddress as AddressExt;

class QuoteSelectedShippingCurrency extends QuoteShippingCurrency {
    /**
     * @var QuoteExt
     */
    protected $quote;

    /**
     * @param array{currency:Currency} $amounts
     * @param ?array{min:Points, max:Points, value:Points} $points
     * @param QuoteExt $quote
     */
    public function __construct(
        array $amounts,
        ?array $points,
        Mage_Sales_Model_Quote $quote
    ) {
        parent::__construct($amounts, $points);

        $this->quote = $quote;
    }

    public function getRemaining(): MageQL_Core_Model_Price_Abstract {
        /**
         * @var AddressExt
         */
        $shipping = $this->quote->getShippingAddress();

        return new QuoteCurrencyTotal(
            $shipping->getShippingAmount() +
            $shipping->getShippingHiddenTaxAmount() -
            $shipping->getShippingDiscountAmount() -
            $shipping->getPointsShippingTotal(),
            false,
            $shipping->getShippingTaxAmount() -
            $shipping->getPointsShippingTaxTotal()
        );
    }
}
