<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Points\Core\QuoteAddressTotal;

class QuoteSelected extends Quote {
    public function getPoints(): QuotePoints {
        return new QuoteSelectedPoints($this->getTotals(), $this->quote, $this->provider);
    }

    public function getCurrency(): QuoteCurrency {
        return new QuoteSelectedCurrency($this->getTotals(), $this->quote);
    }

    public function getShipping(): ?QuoteShipping {
        if($this->quote->isVirtual()) {
            return null;
        }

        $amounts = $this->getShippingAmounts();

        if( ! $amounts) {
            return null;
        }

        return new QuoteSelectedShipping($this->getTotals(), $amounts, $this->quote);
    }

    public function getDiscount(): ?QuoteDiscount {
        $totals = $this->getTotals();
        $discount = array_values(array_filter(array_merge(...array_map(function(QuoteAddressTotal $t): array {
            return $t->getDiscount();
        }, $totals))));
        $discountPoints = array_values(array_filter(array_merge(...array_map(function(QuoteAddressTotal $t): array {
            return $t->getPointsDiscount();
        }, $totals))));

        if(empty($discount)) {
            return null;
        }

        return new QuoteSelectedDiscount($discount, $discountPoints, $this->quote);
    }
}
