<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use Mage_Sales_Model_Quote_Item;
use MageQL_Catalog_Model_Product_Price;
use Mage_Catalog_Model_Product;

use Points\Core\QuoteAddressTotal;
use Points\Core\Extension\QuoteItem;

class QuoteItemPoints {
    /**
     * @var QuoteAddressTotal
     */
    protected $totals;

    /**
     * @var QuoteItem
     */
    protected $item;

    /**
     * @param QuoteItem $item
     */
    public function __construct(
        QuoteAddressTotal $totals,
        Mage_Sales_Model_Quote_Item $item
    ) {
        $this->totals = $totals;
        $this->item = $item;
    }

    public function getMin(): TotalInterface {
        $min = $this->totals->getRowPointsMin($this->item);

        return new QuoteItemPointsTotal(
            $min ? $min->getTotalExclTax() : 0,
            $min ? $min->getTax() : 0
        );
    }

    public function getMax(): TotalInterface {
        $value = $this->totals->getRowPointsValue($this->item);
        $max = $this->totals->getRowPointsMax($this->item) ?: $value;

        return new QuoteItemPointsTotal(
            $max ? $max->getTotalExclTax() : 0,
            $max ? $max->getTax() : 0
        );
    }

    public function getValue(): TotalInterface {
        return new QuoteItemPointsTotal(
            (int)$this->item->getPointsRowValue(),
            (int)$this->item->getPointsRowTaxValue()
        );
    }

    public function getSelected(): TotalInterface {
        return new QuoteItemPointsTotal(
            (int)$this->item->getPointsRowPoints(),
            (int)$this->item->getPointsRowTaxPoints()
        );
    }
}
