<?php

declare(strict_types=1);

namespace Points\Core\Schema;

use MageQL_Catalog_Model_Product_Price;
use Mage_Catalog_Model_Product;
use Points_Core_Model_Product_Index;
use Points_Core_Model_Product_Price;

class ProductPoints {
    /**
     * @var Points_Core_Model_Product_Price|Points_Core_Model_Product_Index
     */
    protected $points;

    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    /**
     * @param Points_Core_Model_Product_Price|Points_Core_Model_Product_Index $points
     */
    public function __construct(
        Mage_Catalog_Model_Product $product,
        $points
    ) {
        $this->points = $points;
        $this->product = $product;
    }

    public function getMin(): TotalInterface {
        return new ProductPointsTotal(
            $this->product,
            (int)$this->points->getMinPrice()
        );
    }

    public function getMax(): TotalInterface {
        $points = $this->points->getMaxPrice() ?: $this->points->getPrice();

        return new ProductPointsTotal(
            $this->product,
            (int)$points
        );
    }

    public function getValue(): TotalInterface {
        return new ProductPointsTotal(
            $this->product,
            (int)$this->points->getPrice()
        );
    }
}
