<?php

declare(strict_types=1);

namespace Points\Core;

class Total {
    /**
     * @var Array<Currency>
     */
    protected $currency;

    /**
     * @var Array<Points>
     */
    protected $minPoints;

    /**
     * @var Array<Points>
     */
    protected $maxPoints;

    /**
     * @var Array<Points>
     */
    protected $points;

    /**
     * @param Array<Currency> $currency
     * @param Array<Points> $minPoints
     * @param Array<Points> $maxPoints
     * @param Array<Points> $points
     */
    public function __construct(
        array $currency,
        array $minPoints,
        array $maxPoints,
        array $points
    ) {
        $this->currency = $currency;
        $this->minPoints = $minPoints;
        $this->maxPoints = $maxPoints;
        $this->points = $points;
    }

    /**
     * @return Array<Points>
     */
    public function getPointsMax(): array {
        return $this->maxPoints;
    }

    /**
     * @return Array<Points>
     */
    public function getPointsMin(): array {
        return $this->minPoints;
    }

    /**
     * @return Array<Points>
     */
    public function getPointsValue(): array {
        return $this->points;
    }

    /**
     * @return Array<Currency>
     */
    public function getCurrency(): array {
        return $this->currency;
    }
}
