<?php

declare(strict_types=1);

use Points\Core\QuoteAddressTotal;
use Points\Core\Points;
use Points\Core\Total;

class Points_Core_Model_Schema_SelectedQuotePointPaymentMethod extends Points_Core_Model_Schema_QuotePointPaymentMethod {
    public function getPoints(): Points_Core_Model_Schema_QuotePointTotal {
        return new Points_Core_Model_Schema_QuotePointTotal($this->quote);
    }

    /**
     * @psalm-suppress RedundantCast
     */
    public function getPointsInCurrency(array $unusedArgs, MageQL_Core_Model_Context $ctx): Varien_Object {
        return new Varien_Object([
            "inc_vat" => (float)round(abs(-(float)$this->quote->getPointsAmount() + $this->quote->getPointsTaxAmount()), 2),
            "ex_vat" => (float)round(abs((float)$this->quote->getPointsAmount()), 2),
            "vat" => (float)round(abs((float)$this->quote->getPointsTaxAmount()), 2),
        ]);
    }
}
