<?php

declare(strict_types=1);

use Points\Core\Points;
use Points\Core\Total;
use Points\Core\Extension\Order;
use Points\Core\ProviderInterface;

class Points_Core_Model_Schema_SelectedOrderPointPaymentMethod {
    /**
     * @var string
     */
    protected $type;

    /**
     * @var Order
     */
    protected $order;

    /**
     * @var ?ProviderInterface
     */
    protected $provider;

    public function __construct(
        string $type,
        Mage_Sales_Model_Order $order,
        ?ProviderInterface $provider = null
    ) {
        $this->type = $type;
        /**
         * @var Order
         */
        $this->order = $order;
        $this->provider = $provider;
    }

    public function getId(): string {
        return $this->type;
    }

    public function getLabel(): ?string {
        return $this->provider ? $this->provider->getLabel($this->order->getStore()) : null;
    }

    public function getPoints(): Points_Core_Model_Schema_OrderPointTotal {
        return new Points_Core_Model_Schema_OrderPointTotal($this->order);
    }

    /**
     * @psalm-suppress RedundantCast
     */
    public function getPointsInCurrency(array $unusedArgs, MageQL_Core_Model_Context $ctx): Varien_Object {
        return new Varien_Object([
            "inc_vat" => (float)round(abs(-(float)$this->order->getPointsAmount() + $this->order->getPointsTaxAmount()), 2),
            "ex_vat" => (float)round(abs((float)$this->order->getPointsAmount()), 2),
            "vat" => (float)round(abs((float)$this->order->getPointsTaxAmount()), 2),
        ]);
    }
}
