<?php

declare(strict_types=1);

use Points\Core\ProviderInterface;

class Points_Core_Model_Schema_CustomerPointsBalance {
    /**
     * @var string
     */
    protected $type;

    /**
     * @var ProviderInterface
     */
    protected $provider;

    /**
     * @var Mage_Customer_Model_Customer
     */
    protected $customer;

    public function __construct(
        string $type,
        ProviderInterface $provider,
        Mage_Customer_Model_Customer $customer
    ) {
        $this->type = $type;
        $this->provider = $provider;
        $this->customer = $customer;
    }

    public function getId(): string {
        return $this->type;
    }

    public function getLabel(array $unusedArgs, MageQL_Core_Model_Context $ctx): string {
        return $this->provider->getLabel($ctx->getStore());
    }

    public function getPoints(array $unusedArgs, MageQL_Core_Model_Context $ctx): int {
        return $this->provider->getCustomerPointsBalance($ctx->getStore(), $this->customer);
    }

    public function getRedemptionAllowed(array $unusedArgs, MageQL_Core_Model_Context $ctx): bool {
        return $this->provider->getCustomerRedemptionAllowed($ctx->getStore(), $this->customer);
    }

    public function getSpendingLimit(
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): ?Points_Core_Model_Schema_PointsSpendingLimit {
        $model = Mage::getResourceModel("points_core/limit_total");

        $limits = $model->getMatchingLimits($ctx->getStore(), $this->customer->getGroupId(), [$this->type]);

        if(empty($limits[$this->type]) || $limits[$this->type]->getLimit() === null) {
            return null;
        }

        return new Points_Core_Model_Schema_PointsSpendingLimit($this->customer, $this->type, $limits[$this->type]);
    }
}
